//*************************************************
// file			: MQ6801_TC0_16Bit.c
// version		: V1.1 2021/02/24
// brief		: 16-bit TC0 related functions
// note			: 16-bit TC0 related functions are gathered in this subroutine
//*************************************************

#include "main.h"


//*********************************************************************
// name			: T001_16bitTimer_Init
// brief		: T001_16bitTimer_Init initialization
// note			:
//*********************************************************************
void T001_16bitTimer_Init(void)
{
//====== pin configuration ======	
	
	
//====== enable function ======
    POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    T001CR_TCAS     = 1;                // cascade timers 
    T01MOD_TFF      = 1;                // set initial state of function pin to high    


    T01MOD_TCM      = 0;                // set operation mode to 16-bit timer mode  
    T01MOD_DBE      = 1;                // enable the double buffer
    T01MOD_TCK      = 5;                // fcgck/4 = 1MHz= 1us =0.001ms   
    
    T00REG          = 100;
    T01REG          = 200;              // Timer Period =    51300        / 1MHz = 51.3 ms
                                        //               (200*256 + 100)
										//                   51300*0.001ms=51.3ms 
	
    NOP;                                // no operation
}


//*********************************************************************
// name			: T001_16bitPPG_Init
// brief		: T001_16bitPPG_Init initialization
// note			:
//*********************************************************************
void T001_16bitPPG_Init(void)
{
//====== pin configuration ======
    P7DR_P1         = 1;                // set P71 to output high (suggest output level as the same as the value of T0xMOD_TFF)
    P7CR_P1         = 1;                // set P71 as output pin

//====== enable function ======
    POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    T001CR_TCAS     = 1;                // cascade timers 
    T01MOD_TFF      = 1;                // set initial state of function pin to high    
    
    T01MOD_TCM      = 3;                // set operation mode to 16-bit PPG mode
    T01MOD_TCK      = 7;                // TCK = fcgck = 4MHz=0.25us=0.00025ms  
    T01MOD_DBE      = 1;                // enable the double buffer
		
    T00REG          = 50;
    T01REG          = 100;              // Timer Period =    25650          /  4MHz  =  6.4 ms  (6.4125ms)
                                        //               (100*256 + 50)
    
    T00PWM          = 40;   
    T01PWM          = 80;               // REG  = (80*256+40) =  20520
										// Duty = PWM/REG
										// Duty = 20520 / 25650  = 80%

//  ***set function pins after function initialization
    P7FC_P1         = 1;                // set P71 as PPG function pin
    
    NOP;                                // no operation
}


//*********************************************************************
// name			: T001_16bit_Start
// brief		: start to run 16-bit TC0
// note			:
//*********************************************************************
void T001_16bit_Start(void)
{
    T001CR_T01RUN = 1;
}



//*********************************************************************
// name			: T001_16bit_Stop
// brief		: stop runnning 16-bit TC0
// note			:
//*********************************************************************
void T001_16bit_Stop(void)
{
    T001CR_T01RUN = 0;
}


//*********************************************************************
// name			: T001_16bit_IntEnable
// brief		: enable TC001 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void T001_16bit_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTC01 = 0;                     // clear interrupt latch
    EI_INTTC01 = 1;                     // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}

//*********************************************************************
// name			: T001_16bit_IntDisable
// brief		: disable TC001 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void T001_16bit_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTTC01 = 0;                     // clear interrupt enable flag
    IL_INTTC01 = 0;                     // clear interrupt latch
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: T001_16bit_SetDuty
// brief		: set duty cycle
// note			: duty cycle = [T01PWM:T00PWM] / [T01REG:T00REG]
//*********************************************************************
void T001_16bit_SetDuty(uint pwmDuty)
{    
    T00PWM = pwmDuty&0xff;              // set low-order first
    T01PWM = pwmDuty>>8;                // then high-order
}

//*********************************************************************
// name			: T001_16bit_SetPeriod
// brief		: set period
// note			: 
//*********************************************************************
void T001_16bit_SetPeriod(uint period)
{    
    T00REG = period&0xff;               // set low-order first
    T01REG = period>>8;                 // then high-order
}

//*********************************************************************
// name			: IntTC01
// brief		: TC01 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTC01(void)
{    
	P9DR_P0 = !P9DR_P0;					// reverse P90 output level
    NOP;                                // no operation
    
    
}











